####################################################################################
#                                                                                  #
#  A robust approach for identification of cancer biomarkers and candidate drugs   #
#  by Md. Shahjaman et al.                                                         #
#                                                                                  #
####################################################################################

####################################################################################
#                                                                                  #
# Generate simulated dataset                                                       #
#                                                                                  #
####################################################################################

source("rSAM_FC_r_Code.r")

# Performance evaluation in absence of outliers
nG=1000;n1=n2=3;pde=0.1;var0=0.1
Simdat=Sim2Group(nG,n1,n2,var0,pde)

x=Simdat$outmat
TrueDE=Simdat$DEtrue

sam_val=rsam(x,n1,nperms = 20)

rtt=sam_val$tt
rFC=sam_val$RFC

prop_score<-TopN_Thr2(rtt,rFC,TopN=nG)$score

TopDEn<-seq(nG*pde/10, pde*nG, length=10)

Prop_perform<-Rate.FDR.TopG(prop_score,TrueDE,TopDEn,decreasing=TRUE);

# Performance evaluation in presence of outliers
OutSimdat=x
OutInx=sample(1:dim(OutSimdat)[1])[1:100]
OutCol<-sample(1:dim(OutSimdat)[2])[1]
for (jj in 1:length(OutInx)){
OUT<-runif(length(OutCol), min = 5+max(abs(OutSimdat[OutInx[jj],])),
max =10+max(abs(OutSimdat[OutInx[jj],])))
OutSimdat[OutInx[jj],OutCol]<-OUT
}

sam_val2=rsam(OutSimdat,n1,nperms = 20)
rtt2=sam_val2$tt
rFC2=sam_val2$RFC
prop_score2=TopN_Thr2(rtt2,rFC2,nG)$score
Prop_perform2<-Rate.FDR.TopG(prop_score2,TrueDE,TopDEn,decreasing=TRUE);


plot(Prop_perform$FPR,Prop_perform$TPR,type="l",xlab="FPR",ylab="TPR")
points(Prop_perform2$FPR,Prop_perform2$TPR,type="l",xlab="FPR",ylab="TPR",col=2)

legend("bottomright",c("In absence of outliers","In presence of outliers"),lwd=2,col=c(1,2),cex=0.8)


##################################################
#                                                #
#  Performance evaluation using Spike Dataset    #
#                                                #
##################################################

load(file = "SpikeData.rda")
dim(SpikeData)

TrueDE=SpikeData[,2]

# Performance evaluation in absence of outliers

sam_val_spike=rsam(SpikeData[,3:20],n1=9,nperms = 20)

rtt=sam_val_spike$tt
rFC=sam_val_spike$RFC

nG=dim(SpikeData)[1]

pde=sum(TrueDE==1)/nG

prop_score<-TopN_Thr2(rtt,rFC,TopN=nG)$score

TopDEn<-seq(nG*pde/10, pde*nG, length=10)

Prop_perform<-Rate.FDR.TopG(prop_score,TrueDE,TopDEn,decreasing=TRUE);

# Performance evaluation in presence of outliers

OutSimdat=SpikeData[,3:20]
OutInx=sample(1:dim(OutSimdat)[1])[1:1000]
OutCol<-sample(1:dim(OutSimdat)[2])[1]
for (jj in 1:length(OutInx)){
OUT<-runif(length(OutCol), min = 5+max(abs(OutSimdat[OutInx[jj],])),
max =10+max(abs(OutSimdat[OutInx[jj],])))
OutSimdat[OutInx[jj],OutCol]<-OUT
}

sam_val2=rsam(OutSimdat,n1=9,nperms = 20)
tt2=sam_val2$tt
FC2=sam_val2$RFC
prop_score2=TopN_Thr2(tt2,FC2,nG)$score
Prop_perform2<-Rate.FDR.TopG(prop_score2,TrueDE,TopDEn,decreasing=TRUE);

plot(Prop_perform$FPR,Prop_perform$TPR,type="l",xlab="FPR",ylab="TPR")
points(Prop_perform2$FPR,Prop_perform2$TPR,type="l",xlab="FPR",ylab="TPR",col=2)

legend("bottomright",c("In absence of outliers","In presence of outliers"),lwd=2,col=c(1,2),cex=0.8)


####################################################################################
#                                                                                  #
#                         END                                                      #
#                                                                                  #
####################################################################################




